/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AccountLinkActionDto;
import io.nem.catapult.builders.AccountLinkTransactionBodyBuilder;
import io.nem.catapult.builders.AmountDto;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.SignatureDto;
import io.nem.catapult.builders.TimestampDto;
import io.nem.catapult.builders.TransactionBuilder;
import java.io.DataInputStream;

public final class AccountLinkTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final AccountLinkTransactionBodyBuilder accountLinkTransactionBody;

    protected AccountLinkTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.accountLinkTransactionBody = AccountLinkTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected AccountLinkTransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, KeyDto remotePublicKey, AccountLinkActionDto linkAction) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        this.accountLinkTransactionBody = AccountLinkTransactionBodyBuilder.create(remotePublicKey, linkAction);
    }

    public static AccountLinkTransactionBuilder create(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, KeyDto remotePublicKey, AccountLinkActionDto linkAction) {
        return new AccountLinkTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, remotePublicKey, linkAction);
    }

    public KeyDto getRemotePublicKey() {
        return this.accountLinkTransactionBody.getRemotePublicKey();
    }

    public AccountLinkActionDto getLinkAction() {
        return this.accountLinkTransactionBody.getLinkAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.accountLinkTransactionBody.getSize();
    }

    public static AccountLinkTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new AccountLinkTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] accountLinkTransactionBodyBytes = this.accountLinkTransactionBody.serialize();
            dataOutputStream.write(accountLinkTransactionBodyBytes, 0, accountLinkTransactionBodyBytes.length);
        });
    }
}

