/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AccountRestrictionFlagsDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.UnresolvedAddressDto;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class AccountAddressRestrictionTransactionBodyBuilder
implements Serializer {
    private final EnumSet<AccountRestrictionFlagsDto> restrictionFlags;
    private final int accountRestrictionTransactionBody_Reserved1;
    private final List<UnresolvedAddressDto> restrictionAdditions;
    private final List<UnresolvedAddressDto> restrictionDeletions;

    protected AccountAddressRestrictionTransactionBodyBuilder(DataInputStream stream) {
        try {
            int i;
            this.restrictionFlags = GeneratorUtils.toSet(AccountRestrictionFlagsDto.class, Short.reverseBytes(stream.readShort()));
            int restrictionAdditionsCount = stream.readByte();
            int restrictionDeletionsCount = stream.readByte();
            this.accountRestrictionTransactionBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.restrictionAdditions = new ArrayList<UnresolvedAddressDto>(restrictionAdditionsCount);
            for (i = 0; i < restrictionAdditionsCount; ++i) {
                this.restrictionAdditions.add(UnresolvedAddressDto.loadFromBinary(stream));
            }
            this.restrictionDeletions = new ArrayList<UnresolvedAddressDto>(restrictionDeletionsCount);
            for (i = 0; i < restrictionDeletionsCount; ++i) {
                this.restrictionDeletions.add(UnresolvedAddressDto.loadFromBinary(stream));
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected AccountAddressRestrictionTransactionBodyBuilder(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<UnresolvedAddressDto> restrictionAdditions, List<UnresolvedAddressDto> restrictionDeletions) {
        GeneratorUtils.notNull(restrictionFlags, "restrictionFlags is null", new Object[0]);
        GeneratorUtils.notNull(restrictionAdditions, "restrictionAdditions is null", new Object[0]);
        GeneratorUtils.notNull(restrictionDeletions, "restrictionDeletions is null", new Object[0]);
        this.restrictionFlags = restrictionFlags;
        this.accountRestrictionTransactionBody_Reserved1 = 0;
        this.restrictionAdditions = restrictionAdditions;
        this.restrictionDeletions = restrictionDeletions;
    }

    public static AccountAddressRestrictionTransactionBodyBuilder create(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<UnresolvedAddressDto> restrictionAdditions, List<UnresolvedAddressDto> restrictionDeletions) {
        return new AccountAddressRestrictionTransactionBodyBuilder(restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    public EnumSet<AccountRestrictionFlagsDto> getRestrictionFlags() {
        return this.restrictionFlags;
    }

    private int getAccountRestrictionTransactionBody_Reserved1() {
        return this.accountRestrictionTransactionBody_Reserved1;
    }

    public List<UnresolvedAddressDto> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public List<UnresolvedAddressDto> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += AccountRestrictionFlagsDto.values()[0].getSize();
        ++size;
        ++size;
        size += 4;
        size += this.restrictionAdditions.stream().mapToInt(o -> o.getSize()).sum();
        return size += this.restrictionDeletions.stream().mapToInt(o -> o.getSize()).sum();
    }

    public static AccountAddressRestrictionTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AccountAddressRestrictionTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            int i;
            short bitMask = (short)GeneratorUtils.toLong(AccountRestrictionFlagsDto.class, this.restrictionFlags);
            dataOutputStream.writeShort(Short.reverseBytes(bitMask));
            dataOutputStream.writeByte((byte)this.restrictionAdditions.size());
            dataOutputStream.writeByte((byte)this.restrictionDeletions.size());
            dataOutputStream.writeInt(Integer.reverseBytes(this.getAccountRestrictionTransactionBody_Reserved1()));
            for (i = 0; i < this.restrictionAdditions.size(); ++i) {
                byte[] restrictionAdditionsBytes = this.restrictionAdditions.get(i).serialize();
                dataOutputStream.write(restrictionAdditionsBytes, 0, restrictionAdditionsBytes.length);
            }
            for (i = 0; i < this.restrictionDeletions.size(); ++i) {
                byte[] restrictionDeletionsBytes = this.restrictionDeletions.get(i).serialize();
                dataOutputStream.write(restrictionDeletionsBytes, 0, restrictionDeletionsBytes.length);
            }
        });
    }
}

