/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BlockDurationDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NamespaceRegistrationTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class NamespaceRegistrationTransactionBodyBuilder
implements Serializer {
    private BlockDurationDto duration;
    private NamespaceIdDto parentId;
    private final NamespaceIdDto id;
    private final NamespaceRegistrationTypeDto registrationType;
    private final ByteBuffer name;

    protected NamespaceRegistrationTransactionBodyBuilder(DataInputStream stream) {
        try {
            long registrationTypeCondition = Long.reverseBytes(stream.readLong());
            this.id = NamespaceIdDto.loadFromBinary(stream);
            this.registrationType = NamespaceRegistrationTypeDto.loadFromBinary(stream);
            if (this.registrationType == NamespaceRegistrationTypeDto.ROOT) {
                this.duration = new BlockDurationDto(registrationTypeCondition);
                this.parentId = null;
            }
            if (this.registrationType == NamespaceRegistrationTypeDto.CHILD) {
                this.parentId = new NamespaceIdDto(registrationTypeCondition);
                this.duration = null;
            }
            byte nameSize = stream.readByte();
            this.name = ByteBuffer.allocate(nameSize);
            stream.readFully(this.name.array());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected NamespaceRegistrationTransactionBodyBuilder(BlockDurationDto duration, NamespaceIdDto id, ByteBuffer name) {
        GeneratorUtils.notNull(duration, "duration is null", new Object[0]);
        GeneratorUtils.notNull(id, "id is null", new Object[0]);
        GeneratorUtils.notNull(name, "name is null", new Object[0]);
        this.duration = duration;
        this.id = id;
        this.name = name;
        this.registrationType = NamespaceRegistrationTypeDto.ROOT;
        this.parentId = null;
    }

    protected NamespaceRegistrationTransactionBodyBuilder(NamespaceIdDto parentId, NamespaceIdDto id, ByteBuffer name) {
        GeneratorUtils.notNull(parentId, "parentId is null", new Object[0]);
        GeneratorUtils.notNull(id, "id is null", new Object[0]);
        GeneratorUtils.notNull(name, "name is null", new Object[0]);
        this.parentId = parentId;
        this.id = id;
        this.name = name;
        this.registrationType = NamespaceRegistrationTypeDto.CHILD;
        this.duration = null;
    }

    public static NamespaceRegistrationTransactionBodyBuilder create(BlockDurationDto duration, NamespaceIdDto id, ByteBuffer name) {
        return new NamespaceRegistrationTransactionBodyBuilder(duration, id, name);
    }

    public static NamespaceRegistrationTransactionBodyBuilder create(NamespaceIdDto parentId, NamespaceIdDto id, ByteBuffer name) {
        return new NamespaceRegistrationTransactionBodyBuilder(parentId, id, name);
    }

    public BlockDurationDto getDuration() {
        if (this.registrationType != NamespaceRegistrationTypeDto.ROOT) {
            throw new IllegalStateException("registrationType is not set to ROOT.");
        }
        return this.duration;
    }

    public NamespaceIdDto getParentId() {
        if (this.registrationType != NamespaceRegistrationTypeDto.CHILD) {
            throw new IllegalStateException("registrationType is not set to CHILD.");
        }
        return this.parentId;
    }

    public NamespaceIdDto getId() {
        return this.id;
    }

    public NamespaceRegistrationTypeDto getRegistrationType() {
        return this.registrationType;
    }

    public ByteBuffer getName() {
        return this.name;
    }

    @Override
    public int getSize() {
        int size = 0;
        if (this.registrationType == NamespaceRegistrationTypeDto.ROOT) {
            size += this.duration.getSize();
        }
        if (this.registrationType == NamespaceRegistrationTypeDto.CHILD) {
            size += this.parentId.getSize();
        }
        size += this.id.getSize();
        size += this.registrationType.getSize();
        ++size;
        return size += this.name.array().length;
    }

    public static NamespaceRegistrationTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new NamespaceRegistrationTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            if (this.registrationType == NamespaceRegistrationTypeDto.ROOT) {
                byte[] durationBytes = this.duration.serialize();
                dataOutputStream.write(durationBytes, 0, durationBytes.length);
            }
            if (this.registrationType == NamespaceRegistrationTypeDto.CHILD) {
                byte[] parentIdBytes = this.parentId.serialize();
                dataOutputStream.write(parentIdBytes, 0, parentIdBytes.length);
            }
            byte[] idBytes = this.id.serialize();
            dataOutputStream.write(idBytes, 0, idBytes.length);
            byte[] registrationTypeBytes = this.registrationType.serialize();
            dataOutputStream.write(registrationTypeBytes, 0, registrationTypeBytes.length);
            dataOutputStream.writeByte((byte)this.name.array().length);
            dataOutputStream.write(this.name.array(), 0, this.name.array().length);
        });
    }
}

