/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class NamespaceMetadataTransactionBodyBuilder
implements Serializer {
    private final KeyDto targetPublicKey;
    private final long scopedMetadataKey;
    private final NamespaceIdDto targetNamespaceId;
    private final short valueSizeDelta;
    private final ByteBuffer value;

    protected NamespaceMetadataTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.targetPublicKey = KeyDto.loadFromBinary(stream);
            this.scopedMetadataKey = Long.reverseBytes(stream.readLong());
            this.targetNamespaceId = NamespaceIdDto.loadFromBinary(stream);
            this.valueSizeDelta = Short.reverseBytes(stream.readShort());
            short valueSize = Short.reverseBytes(stream.readShort());
            this.value = ByteBuffer.allocate(valueSize);
            stream.readFully(this.value.array());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected NamespaceMetadataTransactionBodyBuilder(KeyDto targetPublicKey, long scopedMetadataKey, NamespaceIdDto targetNamespaceId, short valueSizeDelta, ByteBuffer value) {
        GeneratorUtils.notNull(targetPublicKey, "targetPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(targetNamespaceId, "targetNamespaceId is null", new Object[0]);
        GeneratorUtils.notNull(value, "value is null", new Object[0]);
        this.targetPublicKey = targetPublicKey;
        this.scopedMetadataKey = scopedMetadataKey;
        this.targetNamespaceId = targetNamespaceId;
        this.valueSizeDelta = valueSizeDelta;
        this.value = value;
    }

    public static NamespaceMetadataTransactionBodyBuilder create(KeyDto targetPublicKey, long scopedMetadataKey, NamespaceIdDto targetNamespaceId, short valueSizeDelta, ByteBuffer value) {
        return new NamespaceMetadataTransactionBodyBuilder(targetPublicKey, scopedMetadataKey, targetNamespaceId, valueSizeDelta, value);
    }

    public KeyDto getTargetPublicKey() {
        return this.targetPublicKey;
    }

    public long getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public NamespaceIdDto getTargetNamespaceId() {
        return this.targetNamespaceId;
    }

    public short getValueSizeDelta() {
        return this.valueSizeDelta;
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.targetPublicKey.getSize();
        size += 8;
        size += this.targetNamespaceId.getSize();
        size += 2;
        size += 2;
        return size += this.value.array().length;
    }

    public static NamespaceMetadataTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new NamespaceMetadataTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] targetPublicKeyBytes = this.targetPublicKey.serialize();
            dataOutputStream.write(targetPublicKeyBytes, 0, targetPublicKeyBytes.length);
            dataOutputStream.writeLong(Long.reverseBytes(this.getScopedMetadataKey()));
            byte[] targetNamespaceIdBytes = this.targetNamespaceId.serialize();
            dataOutputStream.write(targetNamespaceIdBytes, 0, targetNamespaceIdBytes.length);
            dataOutputStream.writeShort(Short.reverseBytes(this.getValueSizeDelta()));
            dataOutputStream.writeShort(Short.reverseBytes((short)this.value.array().length));
            dataOutputStream.write(this.value.array(), 0, this.value.array().length);
        });
    }
}

