/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;

public final class MultisigAccountModificationTransactionBodyBuilder
implements Serializer {
    private final byte minRemovalDelta;
    private final byte minApprovalDelta;
    private final int multisigAccountModificationTransactionBody_Reserved1;
    private final List<KeyDto> publicKeyAdditions;
    private final List<KeyDto> publicKeyDeletions;

    protected MultisigAccountModificationTransactionBodyBuilder(DataInputStream stream) {
        try {
            int i;
            this.minRemovalDelta = stream.readByte();
            this.minApprovalDelta = stream.readByte();
            int publicKeyAdditionsCount = stream.readByte();
            int publicKeyDeletionsCount = stream.readByte();
            this.multisigAccountModificationTransactionBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.publicKeyAdditions = new ArrayList<KeyDto>(publicKeyAdditionsCount);
            for (i = 0; i < publicKeyAdditionsCount; ++i) {
                this.publicKeyAdditions.add(KeyDto.loadFromBinary(stream));
            }
            this.publicKeyDeletions = new ArrayList<KeyDto>(publicKeyDeletionsCount);
            for (i = 0; i < publicKeyDeletionsCount; ++i) {
                this.publicKeyDeletions.add(KeyDto.loadFromBinary(stream));
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected MultisigAccountModificationTransactionBodyBuilder(byte minRemovalDelta, byte minApprovalDelta, List<KeyDto> publicKeyAdditions, List<KeyDto> publicKeyDeletions) {
        GeneratorUtils.notNull(publicKeyAdditions, "publicKeyAdditions is null", new Object[0]);
        GeneratorUtils.notNull(publicKeyDeletions, "publicKeyDeletions is null", new Object[0]);
        this.minRemovalDelta = minRemovalDelta;
        this.minApprovalDelta = minApprovalDelta;
        this.multisigAccountModificationTransactionBody_Reserved1 = 0;
        this.publicKeyAdditions = publicKeyAdditions;
        this.publicKeyDeletions = publicKeyDeletions;
    }

    public static MultisigAccountModificationTransactionBodyBuilder create(byte minRemovalDelta, byte minApprovalDelta, List<KeyDto> publicKeyAdditions, List<KeyDto> publicKeyDeletions) {
        return new MultisigAccountModificationTransactionBodyBuilder(minRemovalDelta, minApprovalDelta, publicKeyAdditions, publicKeyDeletions);
    }

    public byte getMinRemovalDelta() {
        return this.minRemovalDelta;
    }

    public byte getMinApprovalDelta() {
        return this.minApprovalDelta;
    }

    private int getMultisigAccountModificationTransactionBody_Reserved1() {
        return this.multisigAccountModificationTransactionBody_Reserved1;
    }

    public List<KeyDto> getPublicKeyAdditions() {
        return this.publicKeyAdditions;
    }

    public List<KeyDto> getPublicKeyDeletions() {
        return this.publicKeyDeletions;
    }

    @Override
    public int getSize() {
        int size = 0;
        ++size;
        ++size;
        ++size;
        ++size;
        size += 4;
        size += this.publicKeyAdditions.stream().mapToInt(o -> o.getSize()).sum();
        return size += this.publicKeyDeletions.stream().mapToInt(o -> o.getSize()).sum();
    }

    public static MultisigAccountModificationTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new MultisigAccountModificationTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            int i;
            dataOutputStream.writeByte(this.getMinRemovalDelta());
            dataOutputStream.writeByte(this.getMinApprovalDelta());
            dataOutputStream.writeByte((byte)this.publicKeyAdditions.size());
            dataOutputStream.writeByte((byte)this.publicKeyDeletions.size());
            dataOutputStream.writeInt(Integer.reverseBytes(this.getMultisigAccountModificationTransactionBody_Reserved1()));
            for (i = 0; i < this.publicKeyAdditions.size(); ++i) {
                byte[] publicKeyAdditionsBytes = this.publicKeyAdditions.get(i).serialize();
                dataOutputStream.write(publicKeyAdditionsBytes, 0, publicKeyAdditionsBytes.length);
            }
            for (i = 0; i < this.publicKeyDeletions.size(); ++i) {
                byte[] publicKeyDeletionsBytes = this.publicKeyDeletions.get(i).serialize();
                dataOutputStream.write(publicKeyDeletionsBytes, 0, publicKeyDeletionsBytes.length);
            }
        });
    }
}

