/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BlockDurationDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicFlagsDto;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.MosaicNonceDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.EnumSet;

public final class MosaicDefinitionTransactionBodyBuilder
implements Serializer {
    private final MosaicIdDto id;
    private final BlockDurationDto duration;
    private final MosaicNonceDto nonce;
    private final EnumSet<MosaicFlagsDto> flags;
    private final byte divisibility;

    protected MosaicDefinitionTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.id = MosaicIdDto.loadFromBinary(stream);
            this.duration = BlockDurationDto.loadFromBinary(stream);
            this.nonce = MosaicNonceDto.loadFromBinary(stream);
            this.flags = GeneratorUtils.toSet(MosaicFlagsDto.class, stream.readByte());
            this.divisibility = stream.readByte();
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected MosaicDefinitionTransactionBodyBuilder(MosaicIdDto id, BlockDurationDto duration, MosaicNonceDto nonce, EnumSet<MosaicFlagsDto> flags, byte divisibility) {
        GeneratorUtils.notNull(id, "id is null", new Object[0]);
        GeneratorUtils.notNull(duration, "duration is null", new Object[0]);
        GeneratorUtils.notNull(nonce, "nonce is null", new Object[0]);
        GeneratorUtils.notNull(flags, "flags is null", new Object[0]);
        this.id = id;
        this.duration = duration;
        this.nonce = nonce;
        this.flags = flags;
        this.divisibility = divisibility;
    }

    public static MosaicDefinitionTransactionBodyBuilder create(MosaicIdDto id, BlockDurationDto duration, MosaicNonceDto nonce, EnumSet<MosaicFlagsDto> flags, byte divisibility) {
        return new MosaicDefinitionTransactionBodyBuilder(id, duration, nonce, flags, divisibility);
    }

    public MosaicIdDto getId() {
        return this.id;
    }

    public BlockDurationDto getDuration() {
        return this.duration;
    }

    public MosaicNonceDto getNonce() {
        return this.nonce;
    }

    public EnumSet<MosaicFlagsDto> getFlags() {
        return this.flags;
    }

    public byte getDivisibility() {
        return this.divisibility;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.id.getSize();
        size += this.duration.getSize();
        size += this.nonce.getSize();
        size += MosaicFlagsDto.values()[0].getSize();
        return ++size;
    }

    public static MosaicDefinitionTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicDefinitionTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] idBytes = this.id.serialize();
            dataOutputStream.write(idBytes, 0, idBytes.length);
            byte[] durationBytes = this.duration.serialize();
            dataOutputStream.write(durationBytes, 0, durationBytes.length);
            byte[] nonceBytes = this.nonce.serialize();
            dataOutputStream.write(nonceBytes, 0, nonceBytes.length);
            byte bitMask = (byte)GeneratorUtils.toLong(MosaicFlagsDto.class, this.flags);
            dataOutputStream.writeByte(bitMask);
            dataOutputStream.writeByte(this.getDivisibility());
        });
    }
}

