/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import java.io.DataInputStream;

public enum LockHashAlgorithmDto {
    SHA3_256(0),
    KECCAK_256(1),
    HASH_160(2),
    HASH_256(3);

    private final byte value;

    public byte getValue() {
        return this.value;
    }

    private LockHashAlgorithmDto(byte value) {
        this.value = value;
    }

    public static LockHashAlgorithmDto rawValueOf(byte value) {
        for (LockHashAlgorithmDto current : LockHashAlgorithmDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for LockHashAlgorithmDto.");
    }

    public int getSize() {
        return 1;
    }

    public static LockHashAlgorithmDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return LockHashAlgorithmDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

