/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class Hash512Dto
implements Serializer {
    private final ByteBuffer hash512;

    public Hash512Dto(ByteBuffer hash512) {
        GeneratorUtils.notNull(hash512, "hash512 is null", new Object[0]);
        GeneratorUtils.isTrue(hash512.array().length == 64, "hash512 should be 64 bytes", new Object[0]);
        this.hash512 = hash512;
    }

    public Hash512Dto(DataInputStream stream) {
        try {
            this.hash512 = ByteBuffer.allocate(64);
            stream.readFully(this.hash512.array());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public ByteBuffer getHash512() {
        return this.hash512;
    }

    @Override
    public int getSize() {
        return 64;
    }

    public static Hash512Dto loadFromBinary(DataInputStream stream) {
        return new Hash512Dto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.hash512.array(), 0, this.hash512.array().length));
    }
}

