/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class BalanceTransferReceiptBuilder
extends ReceiptBuilder
implements Serializer {
    private final MosaicBuilder mosaic;
    private final KeyDto senderPublicKey;
    private final AddressDto recipientAddress;

    protected BalanceTransferReceiptBuilder(DataInputStream stream) {
        super(stream);
        this.mosaic = MosaicBuilder.loadFromBinary(stream);
        this.senderPublicKey = KeyDto.loadFromBinary(stream);
        this.recipientAddress = AddressDto.loadFromBinary(stream);
    }

    protected BalanceTransferReceiptBuilder(short version, ReceiptTypeDto type, MosaicBuilder mosaic, KeyDto senderPublicKey, AddressDto recipientAddress) {
        super(version, type);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        GeneratorUtils.notNull(senderPublicKey, "senderPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(recipientAddress, "recipientAddress is null", new Object[0]);
        this.mosaic = mosaic;
        this.senderPublicKey = senderPublicKey;
        this.recipientAddress = recipientAddress;
    }

    public static BalanceTransferReceiptBuilder create(short version, ReceiptTypeDto type, MosaicBuilder mosaic, KeyDto senderPublicKey, AddressDto recipientAddress) {
        return new BalanceTransferReceiptBuilder(version, type, mosaic, senderPublicKey, recipientAddress);
    }

    public MosaicBuilder getMosaic() {
        return this.mosaic;
    }

    public KeyDto getSenderPublicKey() {
        return this.senderPublicKey;
    }

    public AddressDto getRecipientAddress() {
        return this.recipientAddress;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.mosaic.getSize();
        size += this.senderPublicKey.getSize();
        return size += this.recipientAddress.getSize();
    }

    public static BalanceTransferReceiptBuilder loadFromBinary(DataInputStream stream) {
        return new BalanceTransferReceiptBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] mosaicBytes = this.mosaic.serialize();
            dataOutputStream.write(mosaicBytes, 0, mosaicBytes.length);
            byte[] senderPublicKeyBytes = this.senderPublicKey.serialize();
            dataOutputStream.write(senderPublicKeyBytes, 0, senderPublicKeyBytes.length);
            byte[] recipientAddressBytes = this.recipientAddress.serialize();
            dataOutputStream.write(recipientAddressBytes, 0, recipientAddressBytes.length);
        });
    }
}

