/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountRestrictionFlagsDto;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class AccountOperationRestrictionTransactionBodyBuilder
implements Serializer {
    private final EnumSet<AccountRestrictionFlagsDto> restrictionFlags;
    private final int accountRestrictionTransactionBody_Reserved1;
    private final List<EntityTypeDto> restrictionAdditions;
    private final List<EntityTypeDto> restrictionDeletions;

    protected AccountOperationRestrictionTransactionBodyBuilder(DataInputStream stream) {
        try {
            int i;
            this.restrictionFlags = GeneratorUtils.toSet(AccountRestrictionFlagsDto.class, Short.reverseBytes(stream.readShort()));
            int restrictionAdditionsCount = stream.readByte();
            int restrictionDeletionsCount = stream.readByte();
            this.accountRestrictionTransactionBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.restrictionAdditions = new ArrayList<EntityTypeDto>(restrictionAdditionsCount);
            for (i = 0; i < restrictionAdditionsCount; ++i) {
                this.restrictionAdditions.add(EntityTypeDto.loadFromBinary(stream));
            }
            this.restrictionDeletions = new ArrayList<EntityTypeDto>(restrictionDeletionsCount);
            for (i = 0; i < restrictionDeletionsCount; ++i) {
                this.restrictionDeletions.add(EntityTypeDto.loadFromBinary(stream));
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected AccountOperationRestrictionTransactionBodyBuilder(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<EntityTypeDto> restrictionAdditions, List<EntityTypeDto> restrictionDeletions) {
        GeneratorUtils.notNull(restrictionFlags, "restrictionFlags is null", new Object[0]);
        GeneratorUtils.notNull(restrictionAdditions, "restrictionAdditions is null", new Object[0]);
        GeneratorUtils.notNull(restrictionDeletions, "restrictionDeletions is null", new Object[0]);
        this.restrictionFlags = restrictionFlags;
        this.accountRestrictionTransactionBody_Reserved1 = 0;
        this.restrictionAdditions = restrictionAdditions;
        this.restrictionDeletions = restrictionDeletions;
    }

    public static AccountOperationRestrictionTransactionBodyBuilder create(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<EntityTypeDto> restrictionAdditions, List<EntityTypeDto> restrictionDeletions) {
        return new AccountOperationRestrictionTransactionBodyBuilder(restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    public EnumSet<AccountRestrictionFlagsDto> getRestrictionFlags() {
        return this.restrictionFlags;
    }

    private int getAccountRestrictionTransactionBody_Reserved1() {
        return this.accountRestrictionTransactionBody_Reserved1;
    }

    public List<EntityTypeDto> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public List<EntityTypeDto> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += AccountRestrictionFlagsDto.values()[0].getSize();
        ++size;
        ++size;
        size += 4;
        size += this.restrictionAdditions.stream().mapToInt(o -> o.getSize()).sum();
        return size += this.restrictionDeletions.stream().mapToInt(o -> o.getSize()).sum();
    }

    public static AccountOperationRestrictionTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AccountOperationRestrictionTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            int i;
            short bitMask = (short)GeneratorUtils.toLong(AccountRestrictionFlagsDto.class, this.restrictionFlags);
            dataOutputStream.writeShort(Short.reverseBytes(bitMask));
            dataOutputStream.writeByte((byte)this.restrictionAdditions.size());
            dataOutputStream.writeByte((byte)this.restrictionDeletions.size());
            dataOutputStream.writeInt(Integer.reverseBytes(this.getAccountRestrictionTransactionBody_Reserved1()));
            for (i = 0; i < this.restrictionAdditions.size(); ++i) {
                byte[] restrictionAdditionsBytes = this.restrictionAdditions.get(i).serialize();
                dataOutputStream.write(restrictionAdditionsBytes, 0, restrictionAdditionsBytes.length);
            }
            for (i = 0; i < this.restrictionDeletions.size(); ++i) {
                byte[] restrictionDeletionsBytes = this.restrictionDeletions.get(i).serialize();
                dataOutputStream.write(restrictionDeletionsBytes, 0, restrictionDeletionsBytes.length);
            }
        });
    }
}

