/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.TransactionBuilder;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import io.nem.symbol.catapult.builders.VrfKeyLinkTransactionBodyBuilder;
import java.io.DataInputStream;

public class VrfKeyLinkTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final VrfKeyLinkTransactionBodyBuilder vrfKeyLinkTransactionBody;

    protected VrfKeyLinkTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.vrfKeyLinkTransactionBody = VrfKeyLinkTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static VrfKeyLinkTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new VrfKeyLinkTransactionBuilder(stream);
    }

    protected VrfKeyLinkTransactionBuilder(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, AmountDto fee, TimestampDto deadline, PublicKeyDto linkedPublicKey, LinkActionDto linkAction) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(fee, "fee is null", new Object[0]);
        GeneratorUtils.notNull(deadline, "deadline is null", new Object[0]);
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.vrfKeyLinkTransactionBody = new VrfKeyLinkTransactionBodyBuilder(linkedPublicKey, linkAction);
    }

    public static VrfKeyLinkTransactionBuilder create(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, AmountDto fee, TimestampDto deadline, PublicKeyDto linkedPublicKey, LinkActionDto linkAction) {
        return new VrfKeyLinkTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, linkedPublicKey, linkAction);
    }

    public PublicKeyDto getLinkedPublicKey() {
        return this.vrfKeyLinkTransactionBody.getLinkedPublicKey();
    }

    public LinkActionDto getLinkAction() {
        return this.vrfKeyLinkTransactionBody.getLinkAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.vrfKeyLinkTransactionBody.getSize();
    }

    @Override
    public VrfKeyLinkTransactionBodyBuilder getBody() {
        return this.vrfKeyLinkTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.vrfKeyLinkTransactionBody);
        });
    }
}

