/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.FinalizationEpochDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.TransactionBuilder;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import io.nem.symbol.catapult.builders.VotingKeyLinkTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.VotingPublicKeyDto;
import java.io.DataInputStream;

public class VotingKeyLinkTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final VotingKeyLinkTransactionBodyBuilder votingKeyLinkTransactionBody;

    protected VotingKeyLinkTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.votingKeyLinkTransactionBody = VotingKeyLinkTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static VotingKeyLinkTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new VotingKeyLinkTransactionBuilder(stream);
    }

    protected VotingKeyLinkTransactionBuilder(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, AmountDto fee, TimestampDto deadline, VotingPublicKeyDto linkedPublicKey, FinalizationEpochDto startEpoch, FinalizationEpochDto endEpoch, LinkActionDto linkAction) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(fee, "fee is null", new Object[0]);
        GeneratorUtils.notNull(deadline, "deadline is null", new Object[0]);
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(startEpoch, "startEpoch is null", new Object[0]);
        GeneratorUtils.notNull(endEpoch, "endEpoch is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.votingKeyLinkTransactionBody = new VotingKeyLinkTransactionBodyBuilder(linkedPublicKey, startEpoch, endEpoch, linkAction);
    }

    public static VotingKeyLinkTransactionBuilder create(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, AmountDto fee, TimestampDto deadline, VotingPublicKeyDto linkedPublicKey, FinalizationEpochDto startEpoch, FinalizationEpochDto endEpoch, LinkActionDto linkAction) {
        return new VotingKeyLinkTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, linkedPublicKey, startEpoch, endEpoch, linkAction);
    }

    public VotingPublicKeyDto getLinkedPublicKey() {
        return this.votingKeyLinkTransactionBody.getLinkedPublicKey();
    }

    public FinalizationEpochDto getStartEpoch() {
        return this.votingKeyLinkTransactionBody.getStartEpoch();
    }

    public FinalizationEpochDto getEndEpoch() {
        return this.votingKeyLinkTransactionBody.getEndEpoch();
    }

    public LinkActionDto getLinkAction() {
        return this.votingKeyLinkTransactionBody.getLinkAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.votingKeyLinkTransactionBody.getSize();
    }

    @Override
    public VotingKeyLinkTransactionBodyBuilder getBody() {
        return this.votingKeyLinkTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.votingKeyLinkTransactionBody);
        });
    }
}

