/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum TransactionTypeDto implements Serializer
{
    ACCOUNT_KEY_LINK(16716),
    NODE_KEY_LINK(16972),
    AGGREGATE_COMPLETE(16705),
    AGGREGATE_BONDED(16961),
    VOTING_KEY_LINK(16707),
    VRF_KEY_LINK(16963),
    HASH_LOCK(16712),
    SECRET_LOCK(16722),
    SECRET_PROOF(16978),
    ACCOUNT_METADATA(16708),
    MOSAIC_METADATA(16964),
    NAMESPACE_METADATA(17220),
    MOSAIC_DEFINITION(16717),
    MOSAIC_SUPPLY_CHANGE(16973),
    MOSAIC_SUPPLY_REVOCATION(17229),
    MULTISIG_ACCOUNT_MODIFICATION(16725),
    ADDRESS_ALIAS(16974),
    MOSAIC_ALIAS(17230),
    NAMESPACE_REGISTRATION(16718),
    ACCOUNT_ADDRESS_RESTRICTION(16720),
    ACCOUNT_MOSAIC_RESTRICTION(16976),
    ACCOUNT_OPERATION_RESTRICTION(17232),
    MOSAIC_ADDRESS_RESTRICTION(16977),
    MOSAIC_GLOBAL_RESTRICTION(16721),
    TRANSFER(16724);

    private final short value;

    private TransactionTypeDto(short value) {
        this.value = value;
    }

    public static TransactionTypeDto rawValueOf(short value) {
        for (TransactionTypeDto current : TransactionTypeDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for TransactionTypeDto.");
    }

    @Override
    public int getSize() {
        return 2;
    }

    public short getValue() {
        return this.value;
    }

    public static TransactionTypeDto loadFromBinary(DataInputStream stream) {
        try {
            short streamValue = Short.reverseBytes(stream.readShort());
            return TransactionTypeDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeShort(Short.reverseBytes(this.value)));
    }
}

