/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountAddressRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.AccountKeyLinkTransactionBuilder;
import io.nem.symbol.catapult.builders.AccountMetadataTransactionBuilder;
import io.nem.symbol.catapult.builders.AccountMosaicRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.AccountOperationRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.AddressAliasTransactionBuilder;
import io.nem.symbol.catapult.builders.HashLockTransactionBuilder;
import io.nem.symbol.catapult.builders.MosaicAddressRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.MosaicAliasTransactionBuilder;
import io.nem.symbol.catapult.builders.MosaicDefinitionTransactionBuilder;
import io.nem.symbol.catapult.builders.MosaicGlobalRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.MosaicMetadataTransactionBuilder;
import io.nem.symbol.catapult.builders.MosaicSupplyChangeTransactionBuilder;
import io.nem.symbol.catapult.builders.MosaicSupplyRevocationTransactionBuilder;
import io.nem.symbol.catapult.builders.MultisigAccountModificationTransactionBuilder;
import io.nem.symbol.catapult.builders.NamespaceMetadataTransactionBuilder;
import io.nem.symbol.catapult.builders.NamespaceRegistrationTransactionBuilder;
import io.nem.symbol.catapult.builders.NodeKeyLinkTransactionBuilder;
import io.nem.symbol.catapult.builders.SecretLockTransactionBuilder;
import io.nem.symbol.catapult.builders.SecretProofTransactionBuilder;
import io.nem.symbol.catapult.builders.TransactionBuilder;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import io.nem.symbol.catapult.builders.TransferTransactionBuilder;
import io.nem.symbol.catapult.builders.VotingKeyLinkTransactionBuilder;
import io.nem.symbol.catapult.builders.VrfKeyLinkTransactionBuilder;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.SequenceInputStream;

public class TransactionBuilderHelper {
    public static TransactionBuilder loadFromBinary(DataInputStream stream) {
        TransactionBuilder headerBuilder = TransactionBuilder.loadFromBinary(stream);
        DataInputStream concatenate = new DataInputStream(new SequenceInputStream(new ByteArrayInputStream(headerBuilder.serialize()), stream));
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_KEY_LINK && headerBuilder.getVersion() == 1) {
            return AccountKeyLinkTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.NODE_KEY_LINK && headerBuilder.getVersion() == 1) {
            return NodeKeyLinkTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.VOTING_KEY_LINK && headerBuilder.getVersion() == 1) {
            return VotingKeyLinkTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.VRF_KEY_LINK && headerBuilder.getVersion() == 1) {
            return VrfKeyLinkTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.HASH_LOCK && headerBuilder.getVersion() == 1) {
            return HashLockTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.SECRET_LOCK && headerBuilder.getVersion() == 1) {
            return SecretLockTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.SECRET_PROOF && headerBuilder.getVersion() == 1) {
            return SecretProofTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_METADATA && headerBuilder.getVersion() == 1) {
            return AccountMetadataTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_METADATA && headerBuilder.getVersion() == 1) {
            return MosaicMetadataTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.NAMESPACE_METADATA && headerBuilder.getVersion() == 1) {
            return NamespaceMetadataTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_DEFINITION && headerBuilder.getVersion() == 1) {
            return MosaicDefinitionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_SUPPLY_CHANGE && headerBuilder.getVersion() == 1) {
            return MosaicSupplyChangeTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_SUPPLY_REVOCATION && headerBuilder.getVersion() == 1) {
            return MosaicSupplyRevocationTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.MULTISIG_ACCOUNT_MODIFICATION && headerBuilder.getVersion() == 1) {
            return MultisigAccountModificationTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.ADDRESS_ALIAS && headerBuilder.getVersion() == 1) {
            return AddressAliasTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_ALIAS && headerBuilder.getVersion() == 1) {
            return MosaicAliasTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.NAMESPACE_REGISTRATION && headerBuilder.getVersion() == 1) {
            return NamespaceRegistrationTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_ADDRESS_RESTRICTION && headerBuilder.getVersion() == 1) {
            return AccountAddressRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_MOSAIC_RESTRICTION && headerBuilder.getVersion() == 1) {
            return AccountMosaicRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_OPERATION_RESTRICTION && headerBuilder.getVersion() == 1) {
            return AccountOperationRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_ADDRESS_RESTRICTION && headerBuilder.getVersion() == 1) {
            return MosaicAddressRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_GLOBAL_RESTRICTION && headerBuilder.getVersion() == 1) {
            return MosaicGlobalRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        if (headerBuilder.getType() == TransactionTypeDto.TRANSFER && headerBuilder.getVersion() == 1) {
            return TransferTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        throw new RuntimeException("Unknown transaction type " + headerBuilder.getType() + " version " + headerBuilder.getVersion());
    }
}

