/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class TimestampDto
implements Serializer {
    private final long timestamp;

    public TimestampDto(long timestamp) {
        this.timestamp = timestamp;
    }

    public TimestampDto(DataInputStream stream) {
        try {
            this.timestamp = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getSize() {
        return 8;
    }

    public static TimestampDto loadFromBinary(DataInputStream stream) {
        return new TimestampDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeLong(Long.reverseBytes(this.getTimestamp())));
    }
}

