/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.BlockFeeMultiplierDto;
import io.nem.symbol.catapult.builders.BlockHeaderBuilder;
import io.nem.symbol.catapult.builders.BlockTypeDto;
import io.nem.symbol.catapult.builders.DifficultyDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.VrfProofBuilder;
import java.io.DataInputStream;

public class NormalBlockHeaderBuilder
extends BlockHeaderBuilder
implements Serializer {
    private final int blockHeaderReserved1;

    protected NormalBlockHeaderBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.blockHeaderReserved1 = Integer.reverseBytes(stream.readInt());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static NormalBlockHeaderBuilder loadFromBinary(DataInputStream stream) {
        return new NormalBlockHeaderBuilder(stream);
    }

    protected NormalBlockHeaderBuilder(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, BlockTypeDto type, HeightDto height, TimestampDto timestamp, DifficultyDto difficulty, VrfProofBuilder generationHashProof, Hash256Dto previousBlockHash, Hash256Dto transactionsHash, Hash256Dto receiptsHash, Hash256Dto stateHash, AddressDto beneficiaryAddress, BlockFeeMultiplierDto feeMultiplier) {
        super(signature, signerPublicKey, version, network, type, height, timestamp, difficulty, generationHashProof, previousBlockHash, transactionsHash, receiptsHash, stateHash, beneficiaryAddress, feeMultiplier);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(height, "height is null", new Object[0]);
        GeneratorUtils.notNull(timestamp, "timestamp is null", new Object[0]);
        GeneratorUtils.notNull(difficulty, "difficulty is null", new Object[0]);
        GeneratorUtils.notNull(generationHashProof, "generationHashProof is null", new Object[0]);
        GeneratorUtils.notNull(previousBlockHash, "previousBlockHash is null", new Object[0]);
        GeneratorUtils.notNull(transactionsHash, "transactionsHash is null", new Object[0]);
        GeneratorUtils.notNull(receiptsHash, "receiptsHash is null", new Object[0]);
        GeneratorUtils.notNull(stateHash, "stateHash is null", new Object[0]);
        GeneratorUtils.notNull(beneficiaryAddress, "beneficiaryAddress is null", new Object[0]);
        GeneratorUtils.notNull(feeMultiplier, "feeMultiplier is null", new Object[0]);
        this.blockHeaderReserved1 = 0;
    }

    public static NormalBlockHeaderBuilder create(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, BlockTypeDto type, HeightDto height, TimestampDto timestamp, DifficultyDto difficulty, VrfProofBuilder generationHashProof, Hash256Dto previousBlockHash, Hash256Dto transactionsHash, Hash256Dto receiptsHash, Hash256Dto stateHash, AddressDto beneficiaryAddress, BlockFeeMultiplierDto feeMultiplier) {
        return new NormalBlockHeaderBuilder(signature, signerPublicKey, version, network, type, height, timestamp, difficulty, generationHashProof, previousBlockHash, transactionsHash, receiptsHash, stateHash, beneficiaryAddress, feeMultiplier);
    }

    private int getBlockHeaderReserved1() {
        return this.blockHeaderReserved1;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += 4;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            dataOutputStream.writeInt(Integer.reverseBytes(this.getBlockHeaderReserved1()));
        });
    }
}

