/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import java.io.DataInputStream;
import java.util.List;

public class MultisigAccountModificationTransactionBodyBuilder
implements Serializer {
    private final byte minRemovalDelta;
    private final byte minApprovalDelta;
    private final int multisigAccountModificationTransactionBodyReserved1;
    private final List<UnresolvedAddressDto> addressAdditions;
    private final List<UnresolvedAddressDto> addressDeletions;

    protected MultisigAccountModificationTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.minRemovalDelta = stream.readByte();
            this.minApprovalDelta = stream.readByte();
            byte addressAdditionsCount = stream.readByte();
            byte addressDeletionsCount = stream.readByte();
            this.multisigAccountModificationTransactionBodyReserved1 = Integer.reverseBytes(stream.readInt());
            this.addressAdditions = GeneratorUtils.loadFromBinaryArray(UnresolvedAddressDto::loadFromBinary, stream, addressAdditionsCount, 0);
            this.addressDeletions = GeneratorUtils.loadFromBinaryArray(UnresolvedAddressDto::loadFromBinary, stream, addressDeletionsCount, 0);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MultisigAccountModificationTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new MultisigAccountModificationTransactionBodyBuilder(stream);
    }

    protected MultisigAccountModificationTransactionBodyBuilder(byte minRemovalDelta, byte minApprovalDelta, List<UnresolvedAddressDto> addressAdditions, List<UnresolvedAddressDto> addressDeletions) {
        GeneratorUtils.notNull(minRemovalDelta, "minRemovalDelta is null", new Object[0]);
        GeneratorUtils.notNull(minApprovalDelta, "minApprovalDelta is null", new Object[0]);
        GeneratorUtils.notNull(addressAdditions, "addressAdditions is null", new Object[0]);
        GeneratorUtils.notNull(addressDeletions, "addressDeletions is null", new Object[0]);
        this.minRemovalDelta = minRemovalDelta;
        this.minApprovalDelta = minApprovalDelta;
        this.multisigAccountModificationTransactionBodyReserved1 = 0;
        this.addressAdditions = addressAdditions;
        this.addressDeletions = addressDeletions;
    }

    public static MultisigAccountModificationTransactionBodyBuilder create(byte minRemovalDelta, byte minApprovalDelta, List<UnresolvedAddressDto> addressAdditions, List<UnresolvedAddressDto> addressDeletions) {
        return new MultisigAccountModificationTransactionBodyBuilder(minRemovalDelta, minApprovalDelta, addressAdditions, addressDeletions);
    }

    public byte getMinRemovalDelta() {
        return this.minRemovalDelta;
    }

    public byte getMinApprovalDelta() {
        return this.minApprovalDelta;
    }

    private int getMultisigAccountModificationTransactionBodyReserved1() {
        return this.multisigAccountModificationTransactionBodyReserved1;
    }

    public List<UnresolvedAddressDto> getAddressAdditions() {
        return this.addressAdditions;
    }

    public List<UnresolvedAddressDto> getAddressDeletions() {
        return this.addressDeletions;
    }

    @Override
    public int getSize() {
        int size = 0;
        ++size;
        ++size;
        ++size;
        ++size;
        size += 4;
        size += GeneratorUtils.getSumSize(this.addressAdditions, 0);
        return size += GeneratorUtils.getSumSize(this.addressDeletions, 0);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte(this.getMinRemovalDelta());
            dataOutputStream.writeByte(this.getMinApprovalDelta());
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getAddressAdditions()));
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getAddressDeletions()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getMultisigAccountModificationTransactionBodyReserved1()));
            GeneratorUtils.writeList(dataOutputStream, this.addressAdditions, 0);
            GeneratorUtils.writeList(dataOutputStream, this.addressDeletions, 0);
        });
    }
}

