/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedAccountAddressRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedAccountKeyLinkTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedAccountMetadataTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedAccountMosaicRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedAccountOperationRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedAddressAliasTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedHashLockTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedMosaicAddressRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedMosaicAliasTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedMosaicDefinitionTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedMosaicGlobalRestrictionTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedMosaicMetadataTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedMosaicSupplyChangeTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedMosaicSupplyRevocationTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedMultisigAccountModificationTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedNamespaceMetadataTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedNamespaceRegistrationTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedNodeKeyLinkTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedSecretLockTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedSecretProofTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedTransferTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedVotingKeyLinkTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedVrfKeyLinkTransactionBuilder;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.SequenceInputStream;

public class EmbeddedTransactionBuilderHelper {
    public static EmbeddedTransactionBuilder loadFromBinary(DataInputStream stream) {
        EmbeddedTransactionBuilder headerBuilder = EmbeddedTransactionBuilder.loadFromBinary(stream);
        DataInputStream concatenate = new DataInputStream(new SequenceInputStream(new ByteArrayInputStream(headerBuilder.serialize()), stream));
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_KEY_LINK && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountKeyLinkTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.NODE_KEY_LINK && headerBuilder.getVersion() == 1) {
            return EmbeddedNodeKeyLinkTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.VOTING_KEY_LINK && headerBuilder.getVersion() == 1) {
            return EmbeddedVotingKeyLinkTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.VRF_KEY_LINK && headerBuilder.getVersion() == 1) {
            return EmbeddedVrfKeyLinkTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.HASH_LOCK && headerBuilder.getVersion() == 1) {
            return EmbeddedHashLockTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.SECRET_LOCK && headerBuilder.getVersion() == 1) {
            return EmbeddedSecretLockTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.SECRET_PROOF && headerBuilder.getVersion() == 1) {
            return EmbeddedSecretProofTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_METADATA && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountMetadataTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_METADATA && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicMetadataTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.NAMESPACE_METADATA && headerBuilder.getVersion() == 1) {
            return EmbeddedNamespaceMetadataTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_DEFINITION && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicDefinitionTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_SUPPLY_CHANGE && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicSupplyChangeTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_SUPPLY_REVOCATION && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicSupplyRevocationTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.MULTISIG_ACCOUNT_MODIFICATION && headerBuilder.getVersion() == 1) {
            return EmbeddedMultisigAccountModificationTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.ADDRESS_ALIAS && headerBuilder.getVersion() == 1) {
            return EmbeddedAddressAliasTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_ALIAS && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicAliasTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.NAMESPACE_REGISTRATION && headerBuilder.getVersion() == 1) {
            return EmbeddedNamespaceRegistrationTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_ADDRESS_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountAddressRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_MOSAIC_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountMosaicRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_OPERATION_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountOperationRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_ADDRESS_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicAddressRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_GLOBAL_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicGlobalRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
        if (headerBuilder.getType() == TransactionTypeDto.TRANSFER && headerBuilder.getVersion() == 1) {
            return EmbeddedTransferTransactionBuilder.loadFromBinary(concatenate);
        }
        throw new RuntimeException("Unknown transaction type " + headerBuilder.getType() + " version " + headerBuilder.getVersion());
    }
}

