/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.LockHashAlgorithmDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.SecretProofTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class EmbeddedSecretProofTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final SecretProofTransactionBodyBuilder secretProofTransactionBody;

    protected EmbeddedSecretProofTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.secretProofTransactionBody = SecretProofTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedSecretProofTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedSecretProofTransactionBuilder(stream);
    }

    protected EmbeddedSecretProofTransactionBuilder(PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, UnresolvedAddressDto recipientAddress, Hash256Dto secret, LockHashAlgorithmDto hashAlgorithm, ByteBuffer proof) {
        super(signerPublicKey, version, network, type);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(recipientAddress, "recipientAddress is null", new Object[0]);
        GeneratorUtils.notNull(secret, "secret is null", new Object[0]);
        GeneratorUtils.notNull(hashAlgorithm, "hashAlgorithm is null", new Object[0]);
        GeneratorUtils.notNull(proof, "proof is null", new Object[0]);
        this.secretProofTransactionBody = new SecretProofTransactionBodyBuilder(recipientAddress, secret, hashAlgorithm, proof);
    }

    public static EmbeddedSecretProofTransactionBuilder create(PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, UnresolvedAddressDto recipientAddress, Hash256Dto secret, LockHashAlgorithmDto hashAlgorithm, ByteBuffer proof) {
        return new EmbeddedSecretProofTransactionBuilder(signerPublicKey, version, network, type, recipientAddress, secret, hashAlgorithm, proof);
    }

    public UnresolvedAddressDto getRecipientAddress() {
        return this.secretProofTransactionBody.getRecipientAddress();
    }

    public Hash256Dto getSecret() {
        return this.secretProofTransactionBody.getSecret();
    }

    public LockHashAlgorithmDto getHashAlgorithm() {
        return this.secretProofTransactionBody.getHashAlgorithm();
    }

    public ByteBuffer getProof() {
        return this.secretProofTransactionBody.getProof();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.secretProofTransactionBody.getSize();
    }

    @Override
    public SecretProofTransactionBodyBuilder getBody() {
        return this.secretProofTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.secretProofTransactionBody);
        });
    }
}

