/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum BlockTypeDto implements Serializer
{
    NEMESIS(-32701),
    NORMAL(-32445),
    IMPORTANCE(-32189);

    private final short value;

    private BlockTypeDto(short value) {
        this.value = value;
    }

    public static BlockTypeDto rawValueOf(short value) {
        for (BlockTypeDto current : BlockTypeDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for BlockTypeDto.");
    }

    @Override
    public int getSize() {
        return 2;
    }

    public short getValue() {
        return this.value;
    }

    public static BlockTypeDto loadFromBinary(DataInputStream stream) {
        try {
            short streamValue = Short.reverseBytes(stream.readShort());
            return BlockTypeDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeShort(Short.reverseBytes(this.value)));
    }
}

