/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.BlockFeeMultiplierDto;
import io.nem.symbol.catapult.builders.BlockTypeDto;
import io.nem.symbol.catapult.builders.DifficultyDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.VrfProofBuilder;
import java.io.DataInputStream;

public class BlockHeaderBuilder
implements Serializer {
    private int size;
    private final int verifiableEntityHeaderReserved1;
    private final SignatureDto signature;
    private final PublicKeyDto signerPublicKey;
    private final int entityBodyReserved1;
    private final byte version;
    private final NetworkTypeDto network;
    private final BlockTypeDto type;
    private final HeightDto height;
    private final TimestampDto timestamp;
    private final DifficultyDto difficulty;
    private final VrfProofBuilder generationHashProof;
    private final Hash256Dto previousBlockHash;
    private final Hash256Dto transactionsHash;
    private final Hash256Dto receiptsHash;
    private final Hash256Dto stateHash;
    private final AddressDto beneficiaryAddress;
    private final BlockFeeMultiplierDto feeMultiplier;

    protected BlockHeaderBuilder(DataInputStream stream) {
        try {
            this.size = Integer.reverseBytes(stream.readInt());
            this.verifiableEntityHeaderReserved1 = Integer.reverseBytes(stream.readInt());
            this.signature = SignatureDto.loadFromBinary(stream);
            this.signerPublicKey = PublicKeyDto.loadFromBinary(stream);
            this.entityBodyReserved1 = Integer.reverseBytes(stream.readInt());
            this.version = stream.readByte();
            this.network = NetworkTypeDto.loadFromBinary(stream);
            this.type = BlockTypeDto.loadFromBinary(stream);
            this.height = HeightDto.loadFromBinary(stream);
            this.timestamp = TimestampDto.loadFromBinary(stream);
            this.difficulty = DifficultyDto.loadFromBinary(stream);
            this.generationHashProof = VrfProofBuilder.loadFromBinary(stream);
            this.previousBlockHash = Hash256Dto.loadFromBinary(stream);
            this.transactionsHash = Hash256Dto.loadFromBinary(stream);
            this.receiptsHash = Hash256Dto.loadFromBinary(stream);
            this.stateHash = Hash256Dto.loadFromBinary(stream);
            this.beneficiaryAddress = AddressDto.loadFromBinary(stream);
            this.feeMultiplier = BlockFeeMultiplierDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static BlockHeaderBuilder loadFromBinary(DataInputStream stream) {
        return new BlockHeaderBuilder(stream);
    }

    protected BlockHeaderBuilder(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, BlockTypeDto type, HeightDto height, TimestampDto timestamp, DifficultyDto difficulty, VrfProofBuilder generationHashProof, Hash256Dto previousBlockHash, Hash256Dto transactionsHash, Hash256Dto receiptsHash, Hash256Dto stateHash, AddressDto beneficiaryAddress, BlockFeeMultiplierDto feeMultiplier) {
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(height, "height is null", new Object[0]);
        GeneratorUtils.notNull(timestamp, "timestamp is null", new Object[0]);
        GeneratorUtils.notNull(difficulty, "difficulty is null", new Object[0]);
        GeneratorUtils.notNull(generationHashProof, "generationHashProof is null", new Object[0]);
        GeneratorUtils.notNull(previousBlockHash, "previousBlockHash is null", new Object[0]);
        GeneratorUtils.notNull(transactionsHash, "transactionsHash is null", new Object[0]);
        GeneratorUtils.notNull(receiptsHash, "receiptsHash is null", new Object[0]);
        GeneratorUtils.notNull(stateHash, "stateHash is null", new Object[0]);
        GeneratorUtils.notNull(beneficiaryAddress, "beneficiaryAddress is null", new Object[0]);
        GeneratorUtils.notNull(feeMultiplier, "feeMultiplier is null", new Object[0]);
        this.verifiableEntityHeaderReserved1 = 0;
        this.signature = signature;
        this.signerPublicKey = signerPublicKey;
        this.entityBodyReserved1 = 0;
        this.version = version;
        this.network = network;
        this.type = type;
        this.height = height;
        this.timestamp = timestamp;
        this.difficulty = difficulty;
        this.generationHashProof = generationHashProof;
        this.previousBlockHash = previousBlockHash;
        this.transactionsHash = transactionsHash;
        this.receiptsHash = receiptsHash;
        this.stateHash = stateHash;
        this.beneficiaryAddress = beneficiaryAddress;
        this.feeMultiplier = feeMultiplier;
    }

    public static BlockHeaderBuilder create(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, BlockTypeDto type, HeightDto height, TimestampDto timestamp, DifficultyDto difficulty, VrfProofBuilder generationHashProof, Hash256Dto previousBlockHash, Hash256Dto transactionsHash, Hash256Dto receiptsHash, Hash256Dto stateHash, AddressDto beneficiaryAddress, BlockFeeMultiplierDto feeMultiplier) {
        return new BlockHeaderBuilder(signature, signerPublicKey, version, network, type, height, timestamp, difficulty, generationHashProof, previousBlockHash, transactionsHash, receiptsHash, stateHash, beneficiaryAddress, feeMultiplier);
    }

    public int getStreamSize() {
        return this.size;
    }

    private int getVerifiableEntityHeaderReserved1() {
        return this.verifiableEntityHeaderReserved1;
    }

    public SignatureDto getSignature() {
        return this.signature;
    }

    public PublicKeyDto getSignerPublicKey() {
        return this.signerPublicKey;
    }

    private int getEntityBodyReserved1() {
        return this.entityBodyReserved1;
    }

    public byte getVersion() {
        return this.version;
    }

    public NetworkTypeDto getNetwork() {
        return this.network;
    }

    public BlockTypeDto getType() {
        return this.type;
    }

    public HeightDto getHeight() {
        return this.height;
    }

    public TimestampDto getTimestamp() {
        return this.timestamp;
    }

    public DifficultyDto getDifficulty() {
        return this.difficulty;
    }

    public VrfProofBuilder getGenerationHashProof() {
        return this.generationHashProof;
    }

    public Hash256Dto getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public Hash256Dto getTransactionsHash() {
        return this.transactionsHash;
    }

    public Hash256Dto getReceiptsHash() {
        return this.receiptsHash;
    }

    public Hash256Dto getStateHash() {
        return this.stateHash;
    }

    public AddressDto getBeneficiaryAddress() {
        return this.beneficiaryAddress;
    }

    public BlockFeeMultiplierDto getFeeMultiplier() {
        return this.feeMultiplier;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += this.signature.getSize();
        size += this.signerPublicKey.getSize();
        size += 4;
        ++size;
        size += this.network.getSize();
        size += this.type.getSize();
        size += this.height.getSize();
        size += this.timestamp.getSize();
        size += this.difficulty.getSize();
        size += this.generationHashProof.getSize();
        size += this.previousBlockHash.getSize();
        size += this.transactionsHash.getSize();
        size += this.receiptsHash.getSize();
        size += this.stateHash.getSize();
        size += this.beneficiaryAddress.getSize();
        return size += this.feeMultiplier.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getSize()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getVerifiableEntityHeaderReserved1()));
            GeneratorUtils.writeEntity(dataOutputStream, this.signature);
            GeneratorUtils.writeEntity(dataOutputStream, this.signerPublicKey);
            dataOutputStream.writeInt(Integer.reverseBytes(this.getEntityBodyReserved1()));
            dataOutputStream.writeByte(this.getVersion());
            GeneratorUtils.writeEntity(dataOutputStream, this.network);
            GeneratorUtils.writeEntity(dataOutputStream, this.type);
            GeneratorUtils.writeEntity(dataOutputStream, this.height);
            GeneratorUtils.writeEntity(dataOutputStream, this.timestamp);
            GeneratorUtils.writeEntity(dataOutputStream, this.difficulty);
            GeneratorUtils.writeEntity(dataOutputStream, this.generationHashProof);
            GeneratorUtils.writeEntity(dataOutputStream, this.previousBlockHash);
            GeneratorUtils.writeEntity(dataOutputStream, this.transactionsHash);
            GeneratorUtils.writeEntity(dataOutputStream, this.receiptsHash);
            GeneratorUtils.writeEntity(dataOutputStream, this.stateHash);
            GeneratorUtils.writeEntity(dataOutputStream, this.beneficiaryAddress);
            GeneratorUtils.writeEntity(dataOutputStream, this.feeMultiplier);
        });
    }
}

