/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressResolutionEntryBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import java.io.DataInputStream;
import java.util.List;

public class AddressResolutionStatementBuilder
extends ReceiptBuilder
implements Serializer {
    private final UnresolvedAddressDto unresolved;
    private final List<AddressResolutionEntryBuilder> resolutionEntries;

    protected AddressResolutionStatementBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.unresolved = UnresolvedAddressDto.loadFromBinary(stream);
            this.resolutionEntries = GeneratorUtils.loadFromBinaryArrayRemaining(AddressResolutionEntryBuilder::loadFromBinary, stream, 0);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AddressResolutionStatementBuilder loadFromBinary(DataInputStream stream) {
        return new AddressResolutionStatementBuilder(stream);
    }

    protected AddressResolutionStatementBuilder(short version, ReceiptTypeDto type, UnresolvedAddressDto unresolved, List<AddressResolutionEntryBuilder> resolutionEntries) {
        super(version, type);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(unresolved, "unresolved is null", new Object[0]);
        GeneratorUtils.notNull(resolutionEntries, "resolutionEntries is null", new Object[0]);
        this.unresolved = unresolved;
        this.resolutionEntries = resolutionEntries;
    }

    public static AddressResolutionStatementBuilder create(short version, ReceiptTypeDto type, UnresolvedAddressDto unresolved, List<AddressResolutionEntryBuilder> resolutionEntries) {
        return new AddressResolutionStatementBuilder(version, type, unresolved, resolutionEntries);
    }

    public UnresolvedAddressDto getUnresolved() {
        return this.unresolved;
    }

    public List<AddressResolutionEntryBuilder> getResolutionEntries() {
        return this.resolutionEntries;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.unresolved.getSize();
        return size += GeneratorUtils.getSumSize(this.resolutionEntries, 0);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.unresolved);
            GeneratorUtils.writeList(dataOutputStream, this.resolutionEntries, 0);
        });
    }
}

