/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressKeyValueBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class AddressKeyValueSetBuilder
implements Serializer {
    private final List<AddressKeyValueBuilder> keys;

    protected AddressKeyValueSetBuilder(DataInputStream stream) {
        try {
            byte keyValueCount = stream.readByte();
            this.keys = GeneratorUtils.loadFromBinaryArray(AddressKeyValueBuilder::loadFromBinary, stream, keyValueCount, 0);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AddressKeyValueSetBuilder loadFromBinary(DataInputStream stream) {
        return new AddressKeyValueSetBuilder(stream);
    }

    protected AddressKeyValueSetBuilder(List<AddressKeyValueBuilder> keys) {
        GeneratorUtils.notNull(keys, "keys is null", new Object[0]);
        this.keys = keys;
    }

    public static AddressKeyValueSetBuilder create(List<AddressKeyValueBuilder> keys) {
        return new AddressKeyValueSetBuilder(keys);
    }

    public List<AddressKeyValueBuilder> getKeys() {
        return this.keys;
    }

    @Override
    public int getSize() {
        int size = 0;
        ++size;
        return size += GeneratorUtils.getSumSize(this.keys, 0);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getKeys()));
            GeneratorUtils.writeList(dataOutputStream, this.keys, 0);
        });
    }
}

