/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import java.io.DataInputStream;
import java.util.List;

public class AccountRestrictionTransactionTypeValueBuilder
implements Serializer {
    private final List<TransactionTypeDto> restrictionValues;

    protected AccountRestrictionTransactionTypeValueBuilder(DataInputStream stream) {
        try {
            long restrictionValuesCount = Long.reverseBytes(stream.readLong());
            this.restrictionValues = GeneratorUtils.loadFromBinaryArray(TransactionTypeDto::loadFromBinary, stream, restrictionValuesCount, 0);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountRestrictionTransactionTypeValueBuilder loadFromBinary(DataInputStream stream) {
        return new AccountRestrictionTransactionTypeValueBuilder(stream);
    }

    protected AccountRestrictionTransactionTypeValueBuilder(List<TransactionTypeDto> restrictionValues) {
        GeneratorUtils.notNull(restrictionValues, "restrictionValues is null", new Object[0]);
        this.restrictionValues = restrictionValues;
    }

    public static AccountRestrictionTransactionTypeValueBuilder create(List<TransactionTypeDto> restrictionValues) {
        return new AccountRestrictionTransactionTypeValueBuilder(restrictionValues);
    }

    public List<TransactionTypeDto> getRestrictionValues() {
        return this.restrictionValues;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 8;
        return size += GeneratorUtils.getSumSize(this.restrictionValues, 0);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getRestrictionValues())));
            GeneratorUtils.writeList(dataOutputStream, this.restrictionValues, 0);
        });
    }
}

