/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountRestrictionFlagsDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedMosaicIdDto;
import java.io.DataInputStream;
import java.util.EnumSet;
import java.util.List;

public class AccountMosaicRestrictionTransactionBodyBuilder
implements Serializer {
    private final EnumSet<AccountRestrictionFlagsDto> restrictionFlags;
    private final int accountRestrictionTransactionBodyReserved1;
    private final List<UnresolvedMosaicIdDto> restrictionAdditions;
    private final List<UnresolvedMosaicIdDto> restrictionDeletions;

    protected AccountMosaicRestrictionTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.restrictionFlags = GeneratorUtils.toSet(AccountRestrictionFlagsDto.class, Short.reverseBytes(stream.readShort()));
            byte restrictionAdditionsCount = stream.readByte();
            byte restrictionDeletionsCount = stream.readByte();
            this.accountRestrictionTransactionBodyReserved1 = Integer.reverseBytes(stream.readInt());
            this.restrictionAdditions = GeneratorUtils.loadFromBinaryArray(UnresolvedMosaicIdDto::loadFromBinary, stream, restrictionAdditionsCount, 0);
            this.restrictionDeletions = GeneratorUtils.loadFromBinaryArray(UnresolvedMosaicIdDto::loadFromBinary, stream, restrictionDeletionsCount, 0);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountMosaicRestrictionTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AccountMosaicRestrictionTransactionBodyBuilder(stream);
    }

    protected AccountMosaicRestrictionTransactionBodyBuilder(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<UnresolvedMosaicIdDto> restrictionAdditions, List<UnresolvedMosaicIdDto> restrictionDeletions) {
        GeneratorUtils.notNull(restrictionFlags, "restrictionFlags is null", new Object[0]);
        GeneratorUtils.notNull(restrictionAdditions, "restrictionAdditions is null", new Object[0]);
        GeneratorUtils.notNull(restrictionDeletions, "restrictionDeletions is null", new Object[0]);
        this.restrictionFlags = restrictionFlags;
        this.accountRestrictionTransactionBodyReserved1 = 0;
        this.restrictionAdditions = restrictionAdditions;
        this.restrictionDeletions = restrictionDeletions;
    }

    public static AccountMosaicRestrictionTransactionBodyBuilder create(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<UnresolvedMosaicIdDto> restrictionAdditions, List<UnresolvedMosaicIdDto> restrictionDeletions) {
        return new AccountMosaicRestrictionTransactionBodyBuilder(restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    public EnumSet<AccountRestrictionFlagsDto> getRestrictionFlags() {
        return this.restrictionFlags;
    }

    private int getAccountRestrictionTransactionBodyReserved1() {
        return this.accountRestrictionTransactionBodyReserved1;
    }

    public List<UnresolvedMosaicIdDto> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public List<UnresolvedMosaicIdDto> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += AccountRestrictionFlagsDto.values()[0].getSize();
        ++size;
        ++size;
        size += 4;
        size += GeneratorUtils.getSumSize(this.restrictionAdditions, 0);
        return size += GeneratorUtils.getSumSize(this.restrictionDeletions, 0);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeShort(Short.reverseBytes((short)GeneratorUtils.toLong(AccountRestrictionFlagsDto.class, this.restrictionFlags)));
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getRestrictionAdditions()));
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getRestrictionDeletions()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getAccountRestrictionTransactionBodyReserved1()));
            GeneratorUtils.writeList(dataOutputStream, this.restrictionAdditions, 0);
            GeneratorUtils.writeList(dataOutputStream, this.restrictionDeletions, 0);
        });
    }
}

