/**
*** Copyright (c) 2016-2019, Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp.
*** Copyright (c) 2020-present, Jaguar0625, gimre, BloodyRookie.
*** All rights reserved.
***
*** This file is part of Catapult.
***
*** Catapult is free software: you can redistribute it and/or modify
*** it under the terms of the GNU Lesser General Public License as published by
*** the Free Software Foundation, either version 3 of the License, or
*** (at your option) any later version.
***
*** Catapult is distributed in the hope that it will be useful,
*** but WITHOUT ANY WARRANTY; without even the implied warranty of
*** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*** GNU Lesser General Public License for more details.
***
*** You should have received a copy of the GNU Lesser General Public License
*** along with Catapult. If not, see <http://www.gnu.org/licenses/>.
**/

package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;

/**
* Enumeration of Transaction types
**/
public enum TransactionTypeDto implements Serializer {

    /** AccountKeyLinkTransaction. */
    ACCOUNT_KEY_LINK((short)16716L),

    /** NodeKeyLinkTransaction. */
    NODE_KEY_LINK((short)16972L),

    /** AggregateCompleteTransaction. */
    AGGREGATE_COMPLETE((short)16705L),

    /** AggregateBondedTransaction. */
    AGGREGATE_BONDED((short)16961L),

    /** VotingKeyLinkTransaction. */
    VOTING_KEY_LINK((short)16707L),

    /** VrfKeyLinkTransaction. */
    VRF_KEY_LINK((short)16963L),

    /** HashLockTransaction. */
    HASH_LOCK((short)16712L),

    /** SecretLockTransaction. */
    SECRET_LOCK((short)16722L),

    /** SecretProofTransaction. */
    SECRET_PROOF((short)16978L),

    /** AccountMetadataTransaction. */
    ACCOUNT_METADATA((short)16708L),

    /** MosaicMetadataTransaction. */
    MOSAIC_METADATA((short)16964L),

    /** NamespaceMetadataTransaction. */
    NAMESPACE_METADATA((short)17220L),

    /** MosaicDefinitionTransaction. */
    MOSAIC_DEFINITION((short)16717L),

    /** MosaicSupplyChangeTransaction. */
    MOSAIC_SUPPLY_CHANGE((short)16973L),

    /** MosaicSupplyRevocationTransaction. */
    MOSAIC_SUPPLY_REVOCATION((short)17229L),

    /** MultisigAccountModificationTransaction. */
    MULTISIG_ACCOUNT_MODIFICATION((short)16725L),

    /** AddressAliasTransaction. */
    ADDRESS_ALIAS((short)16974L),

    /** MosaicAliasTransaction. */
    MOSAIC_ALIAS((short)17230L),

    /** NamespaceRegistrationTransaction. */
    NAMESPACE_REGISTRATION((short)16718L),

    /** AccountAddressRestrictionTransaction. */
    ACCOUNT_ADDRESS_RESTRICTION((short)16720L),

    /** AccountMosaicRestrictionTransaction. */
    ACCOUNT_MOSAIC_RESTRICTION((short)16976L),

    /** AccountOperationRestrictionTransaction. */
    ACCOUNT_OPERATION_RESTRICTION((short)17232L),

    /** MosaicAddressRestrictionTransaction. */
    MOSAIC_ADDRESS_RESTRICTION((short)16977L),

    /** MosaicGlobalRestrictionTransaction. */
    MOSAIC_GLOBAL_RESTRICTION((short)16721L),

    /** TransferTransaction. */
    TRANSFER((short)16724L);


    /** Enum value. */
    private final short value;

    /**
     * Constructor.
     *
     * @param value Enum value.
     */
     TransactionTypeDto(final short value) {
        this.value = value;
    }

    /**
     * Gets enum value.
     *
     * @param value Raw value of the enum.
     * @return Enum value.
     */
    public static TransactionTypeDto rawValueOf(final short value) {
        for (TransactionTypeDto current : TransactionTypeDto.values()) {
            if (value == current.value) {
                return current;
            }
        }
        throw new IllegalArgumentException(value + " was not a backing value for TransactionTypeDto.");
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 2;
    }

    /**
     * Gets the value of the enum.
     *
     * @return Value of the enum.
     */
    public short getValue() {
        return this.value;
    }
    /**
     * Creates an instance of TransactionTypeDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of TransactionTypeDto.
     */
    public static TransactionTypeDto loadFromBinary(final DataInputStream stream) {
        try {
            final short streamValue = Short.reverseBytes(stream.readShort());
            return rawValueOf(streamValue);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeShort(Short.reverseBytes(this.value));
        });
    }
}

