/**
*** Copyright (c) 2016-2019, Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp.
*** Copyright (c) 2020-present, Jaguar0625, gimre, BloodyRookie.
*** All rights reserved.
***
*** This file is part of Catapult.
***
*** Catapult is free software: you can redistribute it and/or modify
*** it under the terms of the GNU Lesser General Public License as published by
*** the Free Software Foundation, either version 3 of the License, or
*** (at your option) any later version.
***
*** Catapult is distributed in the hope that it will be useful,
*** but WITHOUT ANY WARRANTY; without even the implied warranty of
*** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*** GNU Lesser General Public License for more details.
***
*** You should have received a copy of the GNU Lesser General Public License
*** along with Catapult. If not, see <http://www.gnu.org/licenses/>.
**/

package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.io.SequenceInputStream;
import java.io.ByteArrayInputStream;

/** Factory in charge of creating the right transaction builder from the streamed data. */
public class EmbeddedTransactionBuilderHelper {

    /**
    * It creates the rigth embbeded transaction builder from the stream data.
    *
    * @param stream the stream
    * @return the EmbeddedTransactionBuilder subclass
    */
    public static EmbeddedTransactionBuilder loadFromBinary(final DataInputStream stream) {

        EmbeddedTransactionBuilder headerBuilder = EmbeddedTransactionBuilder.loadFromBinary(stream);
        DataInputStream concatenate = new DataInputStream(new SequenceInputStream(new ByteArrayInputStream(headerBuilder.serialize()), stream));

                                                                                                                                                                                                                                                                                                                                                                                                                                                if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_KEY_LINK && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountKeyLinkTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.NODE_KEY_LINK && headerBuilder.getVersion() == 1) {
            return EmbeddedNodeKeyLinkTransactionBuilder.loadFromBinary(concatenate);
        }
                                        if (headerBuilder.getType() == TransactionTypeDto.VOTING_KEY_LINK && headerBuilder.getVersion() == 1) {
            return EmbeddedVotingKeyLinkTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.VRF_KEY_LINK && headerBuilder.getVersion() == 1) {
            return EmbeddedVrfKeyLinkTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.HASH_LOCK && headerBuilder.getVersion() == 1) {
            return EmbeddedHashLockTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.SECRET_LOCK && headerBuilder.getVersion() == 1) {
            return EmbeddedSecretLockTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.SECRET_PROOF && headerBuilder.getVersion() == 1) {
            return EmbeddedSecretProofTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_METADATA && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountMetadataTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_METADATA && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicMetadataTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.NAMESPACE_METADATA && headerBuilder.getVersion() == 1) {
            return EmbeddedNamespaceMetadataTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_DEFINITION && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicDefinitionTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_SUPPLY_CHANGE && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicSupplyChangeTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_SUPPLY_REVOCATION && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicSupplyRevocationTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.MULTISIG_ACCOUNT_MODIFICATION && headerBuilder.getVersion() == 1) {
            return EmbeddedMultisigAccountModificationTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.ADDRESS_ALIAS && headerBuilder.getVersion() == 1) {
            return EmbeddedAddressAliasTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_ALIAS && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicAliasTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.NAMESPACE_REGISTRATION && headerBuilder.getVersion() == 1) {
            return EmbeddedNamespaceRegistrationTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_ADDRESS_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountAddressRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_MOSAIC_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountMosaicRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.ACCOUNT_OPERATION_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedAccountOperationRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_ADDRESS_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicAddressRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.MOSAIC_GLOBAL_RESTRICTION && headerBuilder.getVersion() == 1) {
            return EmbeddedMosaicGlobalRestrictionTransactionBuilder.loadFromBinary(concatenate);
        }
                    if (headerBuilder.getType() == TransactionTypeDto.TRANSFER && headerBuilder.getVersion() == 1) {
            return EmbeddedTransferTransactionBuilder.loadFromBinary(concatenate);
        }
        throw new RuntimeException("Unknown transaction type " + headerBuilder.getType() + " version "  + headerBuilder.getVersion());
    }

}

