/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MosaicSupplyRevocationTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.TransactionBuilder;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import io.nem.symbol.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;

public class MosaicSupplyRevocationTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final MosaicSupplyRevocationTransactionBodyBuilder mosaicSupplyRevocationTransactionBody;

    protected MosaicSupplyRevocationTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.mosaicSupplyRevocationTransactionBody = MosaicSupplyRevocationTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicSupplyRevocationTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicSupplyRevocationTransactionBuilder(stream);
    }

    protected MosaicSupplyRevocationTransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, UnresolvedAddressDto sourceAddress, UnresolvedMosaicBuilder mosaic) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(fee, "fee is null", new Object[0]);
        GeneratorUtils.notNull(deadline, "deadline is null", new Object[0]);
        GeneratorUtils.notNull(sourceAddress, "sourceAddress is null", new Object[0]);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        this.mosaicSupplyRevocationTransactionBody = new MosaicSupplyRevocationTransactionBodyBuilder(sourceAddress, mosaic);
    }

    public static MosaicSupplyRevocationTransactionBuilder create(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, UnresolvedAddressDto sourceAddress, UnresolvedMosaicBuilder mosaic) {
        return new MosaicSupplyRevocationTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, sourceAddress, mosaic);
    }

    public UnresolvedAddressDto getSourceAddress() {
        return this.mosaicSupplyRevocationTransactionBody.getSourceAddress();
    }

    public UnresolvedMosaicBuilder getMosaic() {
        return this.mosaicSupplyRevocationTransactionBody.getMosaic();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.mosaicSupplyRevocationTransactionBody.getSize();
    }

    @Override
    public MosaicSupplyRevocationTransactionBodyBuilder getBody() {
        return this.mosaicSupplyRevocationTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaicSupplyRevocationTransactionBody);
        });
    }
}

