/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.FinalizationEpochDto;
import io.nem.symbol.catapult.builders.FinalizationPointDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class FinalizationRoundBuilder
implements Serializer {
    private final FinalizationEpochDto epoch;
    private final FinalizationPointDto point;

    protected FinalizationRoundBuilder(DataInputStream stream) {
        try {
            this.epoch = FinalizationEpochDto.loadFromBinary(stream);
            this.point = FinalizationPointDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static FinalizationRoundBuilder loadFromBinary(DataInputStream stream) {
        return new FinalizationRoundBuilder(stream);
    }

    protected FinalizationRoundBuilder(FinalizationEpochDto epoch, FinalizationPointDto point) {
        GeneratorUtils.notNull(epoch, "epoch is null", new Object[0]);
        GeneratorUtils.notNull(point, "point is null", new Object[0]);
        this.epoch = epoch;
        this.point = point;
    }

    public static FinalizationRoundBuilder create(FinalizationEpochDto epoch, FinalizationPointDto point) {
        return new FinalizationRoundBuilder(epoch, point);
    }

    public FinalizationEpochDto getEpoch() {
        return this.epoch;
    }

    public FinalizationPointDto getPoint() {
        return this.point;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.epoch.getSize();
        return size += this.point.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.epoch);
            GeneratorUtils.writeEntity(dataOutputStream, this.point);
        });
    }
}

