package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Unresolved mosaic id. */
public final class UnresolvedMosaicIdDto implements Serializer {
    /** Unresolved mosaic id. */
    private final long unresolvedMosaicId;

    /**
     * Constructor.
     *
     * @param unresolvedMosaicId Unresolved mosaic id.
     */
    public UnresolvedMosaicIdDto(final long unresolvedMosaicId) {
        this.unresolvedMosaicId = unresolvedMosaicId;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public UnresolvedMosaicIdDto(final DataInputStream stream) {
        try {
            this.unresolvedMosaicId = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Unresolved mosaic id.
     *
     * @return Unresolved mosaic id.
     */
    public long getUnresolvedMosaicId() {
        return this.unresolvedMosaicId;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of UnresolvedMosaicIdDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of UnresolvedMosaicIdDto.
     */
    public static UnresolvedMosaicIdDto loadFromBinary(final DataInputStream stream) {
        return new UnresolvedMosaicIdDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getUnresolvedMosaicId()));
        });
    }
}

