package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;

/**
* Enumeration of network types
**/
public enum NetworkTypeDto implements Serializer {

    /** mijin network. */
    MIJIN((byte) 96),

    /** public network. */
    PUBLIC((byte) 104),

    /** private network. */
    PRIVATE((byte) 120),

    /** mijin test network. */
    MIJIN_TEST((byte) 144),

    /** public test network. */
    PUBLIC_TEST((byte) 152),

    /** private test network. */
    PRIVATE_TEST((byte) 168);


    /** Enum value. */
    private final byte value;

    /**
     * Constructor.
     *
     * @param value Enum value.
     */
     NetworkTypeDto(final byte value) {
        this.value = value;
    }

    /**
     * Gets enum value.
     *
     * @param value Raw value of the enum.
     * @return Enum value.
     */
    public static NetworkTypeDto rawValueOf(final byte value) {
        for (NetworkTypeDto current : NetworkTypeDto.values()) {
            if (value == current.value) {
                return current;
            }
        }
        throw new IllegalArgumentException(value + " was not a backing value for NetworkTypeDto.");
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 1;
    }

    /**
     * Gets the value of the enum.
     *
     * @return Value of the enum.
     */
    public byte getValue() {
        return this.value;
    }
    /**
     * Creates an instance of NetworkTypeDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of NetworkTypeDto.
     */
    public static NetworkTypeDto loadFromBinary(final DataInputStream stream) {
        try {
            final byte streamValue = stream.readByte();
            return rawValueOf(streamValue);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte(this.value);
        });
    }
}

