package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Namespace id. */
public final class NamespaceIdDto implements Serializer {
    /** Namespace id. */
    private final long namespaceId;

    /**
     * Constructor.
     *
     * @param namespaceId Namespace id.
     */
    public NamespaceIdDto(final long namespaceId) {
        this.namespaceId = namespaceId;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public NamespaceIdDto(final DataInputStream stream) {
        try {
            this.namespaceId = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Namespace id.
     *
     * @return Namespace id.
     */
    public long getNamespaceId() {
        return this.namespaceId;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of NamespaceIdDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of NamespaceIdDto.
     */
    public static NamespaceIdDto loadFromBinary(final DataInputStream stream) {
        return new NamespaceIdDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getNamespaceId()));
        });
    }
}

