package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Mosaic id. */
public final class MosaicIdDto implements Serializer {
    /** Mosaic id. */
    private final long mosaicId;

    /**
     * Constructor.
     *
     * @param mosaicId Mosaic id.
     */
    public MosaicIdDto(final long mosaicId) {
        this.mosaicId = mosaicId;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public MosaicIdDto(final DataInputStream stream) {
        try {
            this.mosaicId = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Mosaic id.
     *
     * @return Mosaic id.
     */
    public long getMosaicId() {
        return this.mosaicId;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of MosaicIdDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of MosaicIdDto.
     */
    public static MosaicIdDto loadFromBinary(final DataInputStream stream) {
        return new MosaicIdDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getMosaicId()));
        });
    }
}

