package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;

/**
* Lock status for lock transaction
**/
public enum LockStatusDto implements Serializer {

    /** lock is unused. */
    UNUSED((byte) 0),

    /** lock was already used. */
    USED((byte) 1);


    /** Enum value. */
    private final byte value;

    /**
     * Constructor.
     *
     * @param value Enum value.
     */
     LockStatusDto(final byte value) {
        this.value = value;
    }

    /**
     * Gets enum value.
     *
     * @param value Raw value of the enum.
     * @return Enum value.
     */
    public static LockStatusDto rawValueOf(final byte value) {
        for (LockStatusDto current : LockStatusDto.values()) {
            if (value == current.value) {
                return current;
            }
        }
        throw new IllegalArgumentException(value + " was not a backing value for LockStatusDto.");
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 1;
    }

    /**
     * Gets the value of the enum.
     *
     * @return Value of the enum.
     */
    public byte getValue() {
        return this.value;
    }
    /**
     * Creates an instance of LockStatusDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of LockStatusDto.
     */
    public static LockStatusDto loadFromBinary(final DataInputStream stream) {
        try {
            final byte streamValue = stream.readByte();
            return rawValueOf(streamValue);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte(this.value);
        });
    }
}

