package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Height. */
public final class HeightDto implements Serializer {
    /** Height. */
    private final long height;

    /**
     * Constructor.
     *
     * @param height Height.
     */
    public HeightDto(final long height) {
        this.height = height;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public HeightDto(final DataInputStream stream) {
        try {
            this.height = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Height.
     *
     * @return Height.
     */
    public long getHeight() {
        return this.height;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of HeightDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of HeightDto.
     */
    public static HeightDto loadFromBinary(final DataInputStream stream) {
        return new HeightDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getHeight()));
        });
    }
}

