package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Block duration. */
public final class BlockDurationDto implements Serializer {
    /** Block duration. */
    private final long blockDuration;

    /**
     * Constructor.
     *
     * @param blockDuration Block duration.
     */
    public BlockDurationDto(final long blockDuration) {
        this.blockDuration = blockDuration;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public BlockDurationDto(final DataInputStream stream) {
        try {
            this.blockDuration = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Block duration.
     *
     * @return Block duration.
     */
    public long getBlockDuration() {
        return this.blockDuration;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of BlockDurationDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of BlockDurationDto.
     */
    public static BlockDurationDto loadFromBinary(final DataInputStream stream) {
        return new BlockDurationDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getBlockDuration()));
        });
    }
}

