package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Amount. */
public final class AmountDto implements Serializer {
    /** Amount. */
    private final long amount;

    /**
     * Constructor.
     *
     * @param amount Amount.
     */
    public AmountDto(final long amount) {
        this.amount = amount;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public AmountDto(final DataInputStream stream) {
        try {
            this.amount = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Amount.
     *
     * @return Amount.
     */
    public long getAmount() {
        return this.amount;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of AmountDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of AmountDto.
     */
    public static AmountDto loadFromBinary(final DataInputStream stream) {
        return new AmountDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getAmount()));
        });
    }
}

