package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Address. */
public final class AddressDto implements Serializer {
    /** Address. */
    private final ByteBuffer address;

    /**
     * Constructor.
     *
     * @param address Address.
     */
    public AddressDto(final ByteBuffer address) {
        this.address = address;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public AddressDto(final DataInputStream stream) {
        try {
            this.address = GeneratorUtils.readByteBuffer(stream, 24);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Address.
     *
     * @return Address.
     */
    public ByteBuffer getAddress() {
        return this.address;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 24;
    }

    /**
     * Creates an instance of AddressDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of AddressDto.
     */
    public static AddressDto loadFromBinary(final DataInputStream stream) {
        return new AddressDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.address.array(), 0, this.address.array().length);
        });
    }
}

