/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class VrfKeyLinkTransactionBodyBuilder
implements Serializer {
    private final KeyDto linkedPublicKey;
    private final LinkActionDto linkAction;

    protected VrfKeyLinkTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.linkedPublicKey = KeyDto.loadFromBinary(stream);
            this.linkAction = LinkActionDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static VrfKeyLinkTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new VrfKeyLinkTransactionBodyBuilder(stream);
    }

    protected VrfKeyLinkTransactionBodyBuilder(KeyDto linkedPublicKey, LinkActionDto linkAction) {
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.linkedPublicKey = linkedPublicKey;
        this.linkAction = linkAction;
    }

    public static VrfKeyLinkTransactionBodyBuilder create(KeyDto linkedPublicKey, LinkActionDto linkAction) {
        return new VrfKeyLinkTransactionBodyBuilder(linkedPublicKey, linkAction);
    }

    public KeyDto getLinkedPublicKey() {
        return this.linkedPublicKey;
    }

    public LinkActionDto getLinkAction() {
        return this.linkAction;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.linkedPublicKey.getSize();
        return size += this.linkAction.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.linkedPublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.linkAction);
        });
    }
}

