/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class ScopedMetadataKeyDto
implements Serializer {
    private final long scopedMetadataKey;

    public ScopedMetadataKeyDto(long scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
    }

    public ScopedMetadataKeyDto(DataInputStream stream) {
        try {
            this.scopedMetadataKey = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public long getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    @Override
    public int getSize() {
        return 8;
    }

    public static ScopedMetadataKeyDto loadFromBinary(DataInputStream stream) {
        return new ScopedMetadataKeyDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeLong(Long.reverseBytes(this.getScopedMetadataKey())));
    }
}

