/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import io.nem.symbol.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;

public class MosaicSupplyRevocationTransactionBodyBuilder
implements Serializer {
    private final UnresolvedAddressDto sourceAddress;
    private final UnresolvedMosaicBuilder mosaic;

    protected MosaicSupplyRevocationTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.sourceAddress = UnresolvedAddressDto.loadFromBinary(stream);
            this.mosaic = UnresolvedMosaicBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicSupplyRevocationTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicSupplyRevocationTransactionBodyBuilder(stream);
    }

    protected MosaicSupplyRevocationTransactionBodyBuilder(UnresolvedAddressDto sourceAddress, UnresolvedMosaicBuilder mosaic) {
        GeneratorUtils.notNull(sourceAddress, "sourceAddress is null", new Object[0]);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        this.sourceAddress = sourceAddress;
        this.mosaic = mosaic;
    }

    public static MosaicSupplyRevocationTransactionBodyBuilder create(UnresolvedAddressDto sourceAddress, UnresolvedMosaicBuilder mosaic) {
        return new MosaicSupplyRevocationTransactionBodyBuilder(sourceAddress, mosaic);
    }

    public UnresolvedAddressDto getSourceAddress() {
        return this.sourceAddress;
    }

    public UnresolvedMosaicBuilder getMosaic() {
        return this.mosaic;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.sourceAddress.getSize();
        return size += this.mosaic.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.sourceAddress);
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaic);
        });
    }
}

