/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicBuilder
implements Serializer {
    private final MosaicIdDto mosaicId;
    private final AmountDto amount;

    protected MosaicBuilder(DataInputStream stream) {
        try {
            this.mosaicId = MosaicIdDto.loadFromBinary(stream);
            this.amount = AmountDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicBuilder(stream);
    }

    protected MosaicBuilder(MosaicIdDto mosaicId, AmountDto amount) {
        GeneratorUtils.notNull(mosaicId, "mosaicId is null", new Object[0]);
        GeneratorUtils.notNull(amount, "amount is null", new Object[0]);
        this.mosaicId = mosaicId;
        this.amount = amount;
    }

    public static MosaicBuilder create(MosaicIdDto mosaicId, AmountDto amount) {
        return new MosaicBuilder(mosaicId, amount);
    }

    public MosaicIdDto getMosaicId() {
        return this.mosaicId;
    }

    public AmountDto getAmount() {
        return this.amount;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaicId.getSize();
        return size += this.amount.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaicId);
            GeneratorUtils.writeEntity(dataOutputStream, this.amount);
        });
    }
}

