/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class BalanceChangeReceiptBuilder
extends ReceiptBuilder
implements Serializer {
    private final MosaicBuilder mosaic;
    private final AddressDto targetAddress;

    protected BalanceChangeReceiptBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.mosaic = MosaicBuilder.loadFromBinary(stream);
            this.targetAddress = AddressDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static BalanceChangeReceiptBuilder loadFromBinary(DataInputStream stream) {
        return new BalanceChangeReceiptBuilder(stream);
    }

    protected BalanceChangeReceiptBuilder(short version, ReceiptTypeDto type, MosaicBuilder mosaic, AddressDto targetAddress) {
        super(version, type);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        GeneratorUtils.notNull(targetAddress, "targetAddress is null", new Object[0]);
        this.mosaic = mosaic;
        this.targetAddress = targetAddress;
    }

    public static BalanceChangeReceiptBuilder create(short version, ReceiptTypeDto type, MosaicBuilder mosaic, AddressDto targetAddress) {
        return new BalanceChangeReceiptBuilder(version, type, mosaic, targetAddress);
    }

    public MosaicBuilder getMosaic() {
        return this.mosaic;
    }

    public AddressDto getTargetAddress() {
        return this.targetAddress;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.mosaic.getSize();
        return size += this.targetAddress.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaic);
            GeneratorUtils.writeEntity(dataOutputStream, this.targetAddress);
        });
    }
}

