package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Voting key. */
public final class VotingKeyDto implements Serializer {
    /** Voting key. */
    private final ByteBuffer votingKey;

    /**
     * Constructor.
     *
     * @param votingKey Voting key.
     */
    public VotingKeyDto(final ByteBuffer votingKey) {
        this.votingKey = votingKey;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public VotingKeyDto(final DataInputStream stream) {
        try {
            this.votingKey = GeneratorUtils.readByteBuffer(stream, 32);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Voting key.
     *
     * @return Voting key.
     */
    public ByteBuffer getVotingKey() {
        return this.votingKey;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 32;
    }

    /**
     * Creates an instance of VotingKeyDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of VotingKeyDto.
     */
    public static VotingKeyDto loadFromBinary(final DataInputStream stream) {
        return new VotingKeyDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.votingKey.array(), 0, this.votingKey.array().length);
        });
    }
}

