package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Unresolved address. */
public final class UnresolvedAddressDto implements Serializer {
    /** Unresolved address. */
    private final ByteBuffer unresolvedAddress;

    /**
     * Constructor.
     *
     * @param unresolvedAddress Unresolved address.
     */
    public UnresolvedAddressDto(final ByteBuffer unresolvedAddress) {
        this.unresolvedAddress = unresolvedAddress;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public UnresolvedAddressDto(final DataInputStream stream) {
        try {
            this.unresolvedAddress = GeneratorUtils.readByteBuffer(stream, 24);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Unresolved address.
     *
     * @return Unresolved address.
     */
    public ByteBuffer getUnresolvedAddress() {
        return this.unresolvedAddress;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 24;
    }

    /**
     * Creates an instance of UnresolvedAddressDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of UnresolvedAddressDto.
     */
    public static UnresolvedAddressDto loadFromBinary(final DataInputStream stream) {
        return new UnresolvedAddressDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.unresolvedAddress.array(), 0, this.unresolvedAddress.array().length);
        });
    }
}

