package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Timestamp. */
public final class TimestampDto implements Serializer {
    /** Timestamp. */
    private final long timestamp;

    /**
     * Constructor.
     *
     * @param timestamp Timestamp.
     */
    public TimestampDto(final long timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public TimestampDto(final DataInputStream stream) {
        try {
            this.timestamp = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Timestamp.
     *
     * @return Timestamp.
     */
    public long getTimestamp() {
        return this.timestamp;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of TimestampDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of TimestampDto.
     */
    public static TimestampDto loadFromBinary(final DataInputStream stream) {
        return new TimestampDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getTimestamp()));
        });
    }
}

