package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Proof verification hash. */
public final class ProofVerificationHashDto implements Serializer {
    /** Proof verification hash. */
    private final ByteBuffer proofVerificationHash;

    /**
     * Constructor.
     *
     * @param proofVerificationHash Proof verification hash.
     */
    public ProofVerificationHashDto(final ByteBuffer proofVerificationHash) {
        this.proofVerificationHash = proofVerificationHash;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public ProofVerificationHashDto(final DataInputStream stream) {
        try {
            this.proofVerificationHash = GeneratorUtils.readByteBuffer(stream, 16);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Proof verification hash.
     *
     * @return Proof verification hash.
     */
    public ByteBuffer getProofVerificationHash() {
        return this.proofVerificationHash;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 16;
    }

    /**
     * Creates an instance of ProofVerificationHashDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of ProofVerificationHashDto.
     */
    public static ProofVerificationHashDto loadFromBinary(final DataInputStream stream) {
        return new ProofVerificationHashDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.proofVerificationHash.array(), 0, this.proofVerificationHash.array().length);
        });
    }
}

