package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Proof scalar. */
public final class ProofScalarDto implements Serializer {
    /** Proof scalar. */
    private final ByteBuffer proofScalar;

    /**
     * Constructor.
     *
     * @param proofScalar Proof scalar.
     */
    public ProofScalarDto(final ByteBuffer proofScalar) {
        this.proofScalar = proofScalar;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public ProofScalarDto(final DataInputStream stream) {
        try {
            this.proofScalar = GeneratorUtils.readByteBuffer(stream, 32);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Proof scalar.
     *
     * @return Proof scalar.
     */
    public ByteBuffer getProofScalar() {
        return this.proofScalar;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 32;
    }

    /**
     * Creates an instance of ProofScalarDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of ProofScalarDto.
     */
    public static ProofScalarDto loadFromBinary(final DataInputStream stream) {
        return new ProofScalarDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.proofScalar.array(), 0, this.proofScalar.array().length);
        });
    }
}

