package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Mosaic restriction key. */
public final class MosaicRestrictionKeyDto implements Serializer {
    /** Mosaic restriction key. */
    private final long mosaicRestrictionKey;

    /**
     * Constructor.
     *
     * @param mosaicRestrictionKey Mosaic restriction key.
     */
    public MosaicRestrictionKeyDto(final long mosaicRestrictionKey) {
        this.mosaicRestrictionKey = mosaicRestrictionKey;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public MosaicRestrictionKeyDto(final DataInputStream stream) {
        try {
            this.mosaicRestrictionKey = Long.reverseBytes(stream.readLong());
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Mosaic restriction key.
     *
     * @return Mosaic restriction key.
     */
    public long getMosaicRestrictionKey() {
        return this.mosaicRestrictionKey;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 8;
    }

    /**
     * Creates an instance of MosaicRestrictionKeyDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of MosaicRestrictionKeyDto.
     */
    public static MosaicRestrictionKeyDto loadFromBinary(final DataInputStream stream) {
        return new MosaicRestrictionKeyDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getMosaicRestrictionKey()));
        });
    }
}

