package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.nio.ByteBuffer;

/** Key. */
public final class KeyDto implements Serializer {
    /** Key. */
    private final ByteBuffer key;

    /**
     * Constructor.
     *
     * @param key Key.
     */
    public KeyDto(final ByteBuffer key) {
        this.key = key;
    }

    /**
     * Constructor - Creates an object from stream.
     *
     * @param stream Byte stream to use to serialize.
     */
    public KeyDto(final DataInputStream stream) {
        try {
            this.key = GeneratorUtils.readByteBuffer(stream, 32);
        } catch(Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    /**
     * Gets Key.
     *
     * @return Key.
     */
    public ByteBuffer getKey() {
        return this.key;
    }

    /**
     * Gets the size of the object.
     *
     * @return Size in bytes.
     */
    public int getSize() {
        return 32;
    }

    /**
     * Creates an instance of KeyDto from a stream.
     *
     * @param stream Byte stream to use to serialize the object.
     * @return Instance of KeyDto.
     */
    public static KeyDto loadFromBinary(final DataInputStream stream) {
        return new KeyDto(stream);
    }

    /**
     * Serializes an object to bytes.
     *
     * @return Serialized bytes.
     */
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.write(this.key.array(), 0, this.key.array().length);
        });
    }
}

